<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateServicesLicensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services__licenses', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->boolean("enabled")->nullable();
            $table->boolean("required")->nullable();
            $table->unsignedInteger("service_id")->nullable();
            $table->unsignedInteger("license_id")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('services__licenses');
    }
}
