<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffJobFunctionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff__job_functions', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->boolean("enabled")->nullable();
            $table->string("name")->nullable();
            $table->string("abbr")->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff__job_functions');
    }
}
