<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterStaffTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('staff', function (Blueprint $table) {
            $table->dropColumn([
                "supervision",
                "check_in",
                "boarding",
                "eb_collection",
                "ticketing",
                "ramp",
                "walk_out",
                "load_and_balance",
                "lost_and_found",
                "ac_search",
                "ac_access",
            ]);

            $table->unsignedInteger('job_function_id')->nullable()->after("airline_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('staff', function (Blueprint $table) {

            $table->boolean("supervision")->nullable()->after("airline_id");
            $table->boolean("check_in")->nullable()->after("supervision");
            $table->boolean("boarding")->nullable()->after("check_in");
            $table->boolean("eb_collection")->nullable()->after("boarding");
            $table->boolean("ticketing")->nullable()->after("eb_collection");
            $table->boolean("ramp")->nullable()->after("ticketing");
            $table->boolean("walk_out")->nullable()->after("ramp");
            $table->boolean("load_and_balance")->nullable()->after("walk_out");
            $table->boolean("lost_and_found")->nullable()->after("load_and_balance");
            $table->boolean("ac_search")->nullable()->after("lost_and_found");
            $table->boolean("ac_access")->nullable()->after("ac_search");

            $table->dropColumn([
                'job_function_id',
            ]);
        });
    }
}
