<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAirlinesFunctionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airlines__functions', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("airline_id")->nullable();
            $table->unsignedInteger("airport_id")->nullable();
            $table->unsignedInteger('job_function_id')->nullable();

            $table->boolean("departure_service")->nullable();
            $table->integer("dep_staff_req")->nullable();
            $table->integer("dep_staff_min")->nullable();
            $table->integer("dep_report_time")->nullable();
            $table->integer("dep_release_time")->nullable();

            $table->boolean("arrival_service")->nullable();
            $table->integer("arr_staff_req")->nullable();
            $table->integer("arr_staff_min")->nullable();
            $table->integer("arr_report_time")->nullable();
            $table->integer("arr_release_time")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('airlines__functions');
    }
}
