<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPtmNameStrToPassengersFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->string("ptm_name_str")->nullable()->after('group_tcp');
            $table->integer("ptm_pax")->nullable()->after('ptm_name_str');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->dropColumn([
                "ptm_name_str",
                "ptm_pax",
            ]);
        });
    }
}
