<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStaffInfoToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string("cost_center")->nullable()->after('idcard_expiry');
            $table->string("company")->nullable()->after('cost_center');
            $table->integer("min_hours")->nullable()->after('company');
            $table->integer("max_hours")->nullable()->after('min_hours');

            DB::statement('ALTER TABLE s_users MODIFY staff_number VARCHAR(255)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
               "cost_center",
               "company",
               "min_hours",
               "max_hours",
            ]);

            DB::statement('ALTER TABLE s_users MODIFY staff_number INTEGER (11)');

        });
    }
}
