<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEmailIdAndOtherFieldsToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->string("email_type")->nullable()->after("parent_id");
            $table->string("email_id")->nullable()->after("email_type");

            $table->integer("pax_m_actual")->nullable()->after("pax_inf_actual");
            $table->integer("pax_f_actual")->nullable()->after("pax_m_actual");
            $table->integer("pax_ch_actual")->nullable()->after("pax_f_actual");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropColumn([
               "email_type",
               "email_id",
               "pax_m_actual",
               "pax_f_actual",
               "pax_ch_actual",
            ]);
        });
    }
}
