<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTypeAndPartToMessagesPnl extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__pnl', function (Blueprint $table) {
            $table->string("type")->nullable()->after("id");
            $table->integer("part")->nullable()->after("type");
            $table->unsignedInteger("airline_id")->nullable()->after("flight_id");

            $table->integer("pax_c")->nullable()->after("flight_number_id");
            $table->integer("pax_y")->nullable()->after("pax_c");
            $table->integer("pax_inf")->nullable()->after("pax_y");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__pnl', function (Blueprint $table) {
            $table->dropColumn([
                "type",
                "part",
                "airline_id",
                "pax_c",
                "pax_y",
                "pax_inf",
            ]);
        });
    }
}
