<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToPassengersFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->unsignedInteger("parent_id")->nullable()->after("id");
            $table->unsignedInteger("passenger_frequent_flyer_id")->nullable()->after("flight_order_status_id");
            $table->integer("seq_no")->nullable()->after("passenger_frequent_flyer_id");
            $table->string("group_tcp")->nullable()->after("seq_no");
            $table->string("outbound")->nullable()->after("group_tcp");
            $table->string("inbound")->nullable()->after("outbound");
            $table->integer("xbag_qty")->nullable()->after("inbound");
            $table->integer("xbag_wt")->nullable()->after("xbag_qty");
            $table->string("xbag_info")->nullable()->after("xbag_wt");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->dropColumn([
               "parent_id",
               "passenger_frequent_flyer_id",
               "seq_no",
               "group_tcp",
               "outbound",
               "inbound",
               "inbound",
               "inbound",
               "inbound",
               'xbag_qty',
               'xbag_wt',
               'xbag_info',
            ]);
        });
    }
}
