<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToMessagesPtm extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__ptm', function (Blueprint $table) {
            $table->string("status")->nullable()->after("id");
            $table->boolean("important")->nullable()->after("status");
            $table->boolean("seen")->nullable()->after("important");
            $table->boolean("parsed")->nullable()->after("seen");
            $table->unsignedInteger('flight_number_id')->nullable()->after("flight_id");
            $table->text("log")->nullable()->after("data");
            $table->unsignedInteger('created_by')->nullable()->after("updated_at");
            $table->unsignedInteger('updated_by')->nullable()->after("created_by");
            $table->timestamp('deleted_at')->nullable()->after("updated_by");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__ptm', function (Blueprint $table) {
            $table->dropColumn([
                "status",
                "important",
                "seen",
                "parsed",
                "flight_number_id",
                "log",
                "created_by",
                "updated_by",
                "deleted_at",
            ]);
        });
    }
}
