<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagesLog extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages__log', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string("status")->nullable();
            $table->string("message_type")->nullable();
            $table->boolean("important")->nullable();
            $table->boolean("seen")->nullable();
            $table->boolean("parsed")->nullable();
            $table->integer('email_id')->nullable();
            $table->string("message_id")->nullable();
            $table->integer("udate")->nullable();
            $table->unsignedInteger('flight_id')->nullable();
            $table->timestamp('received_datetime')->nullable();
            $table->string('from_email')->nullable();
            $table->string('to_email')->nullable();
            $table->text('email_body')->nullable();
            $table->string('email_title')->nullable();;
            $table->text('data')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('messages__log');
    }
}
