<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagesTpm extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages__tpm', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->integer('email_id')->nullable();
            $table->string("message_id")->nullable();
            $table->integer("udate")->nullable();
            $table->unsignedInteger('flight_id')->nullable();
            $table->timestamp('received_datetime')->nullable();
            $table->string('from_email')->nullable();
            $table->string('to_email')->nullable();
            $table->text('email_body')->nullable();
            $table->string('email_title')->nullable();;
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('messages__tpm');
    }
}
