<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RenameMvtDataToDataInMessagesMvt extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('messages__mvt', function (Blueprint $table) {
            $table->string("message_id")->nullable()->after("email_id");
            $table->integer("udate")->nullable()->after("message_id");
            $table->text("data")->nullable()->after("email_title");
            $table->dropColumn(["mvt_data", "created_by", "updated_by", "deleted_at"]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('messages__mvt', function (Blueprint $table) {
            $table->dropColumn(["data", "message_id", "udate"]);
            $table->text("mvt_data")->nullable()->after("email_title");

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }
}
