<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAirlineIdToFlightsScheduleFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->unsignedInteger("airline_id")->nullable()->after("flight_schedule_id");
            $table->unsignedInteger("operated_by_airline_id")->nullable()->after("airline_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->dropColumn(['airline_id', 'operated_by_airline_id']);
        });
    }
}
