<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDaysToFlightsScheduleFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY std_weekday INTEGER NULL;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY sta_weekday INTEGER NULL;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY std_time TIMESTAMP NULL;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY sta_time TIMESTAMP NULL;");

            $table->string("days")->nullable()->after('discontinue_date');
            $table->time("departure_time")->nullable()->after('days');
            $table->time("arrival_time")->nullable()->after('departure_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {

            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY std_weekday INTEGER;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY sta_weekday INTEGER;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY std_time TIMESTAMP;");
            \DB::statement("ALTER TABLE s_flights__schedule_flights MODIFY sta_time TIMESTAMP;");

            $table->dropColumn(["days", "departure_time", "arrival_time"]);
        });
    }
}
