<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->boolean("enabled")->nullable();
            $table->unsignedInteger("user_id")->nullable();
            $table->unsignedInteger("airline_id")->nullable();
            $table->boolean("supervision")->nullable();
            $table->boolean("check_in")->nullable();
            $table->boolean("boarding")->nullable();
            $table->boolean("eb_collection")->nullable();
            $table->boolean("ticketing")->nullable();
            $table->boolean("ramp")->nullable();
            $table->boolean("walk_out")->nullable();
            $table->boolean("load_and_balance")->nullable();
            $table->boolean("lost_and_found")->nullable();
            $table->boolean("ac_search")->nullable();
            $table->boolean("ac_access")->nullable();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff');
    }
}
