<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldToFlightsScheduleFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->unsignedInteger("aircraft_type_id")->nullable()->after("aircraft_id");
            $table->date("effective_date")->nullable()->after("flight_number_id");
            $table->date("discontinue_date")->nullable()->after("effective_date");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__schedule_flights', function (Blueprint $table) {
            $table->dropColumn(['aircraft_type_id', "effective_date", "discontinue_date"]);
        });
    }
}
