<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddHandlingFieldsToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropForeign("flights_flights_delay_id_foreign");
            $table->dropColumn(['flights_delay_id']);

            $table->integer("capacity_a")->nullable()->after("ata");
            $table->integer("pax_a_booked")->nullable()->after("capacity_y");
            $table->integer("pax_a_actual")->nullable()->after("pax_inf_booked");

            $table->string("gate_boarding")->nullable()->after("utilised");

            $table->integer("meals_a")->nullable()->after("pax_inf_actual");
            $table->integer("meals_c")->nullable()->after("meals_a");
            $table->integer("meals_y")->nullable()->after("meals_c");

            $table->dateTime("briefing")->nullable()->after("meals_y");
            $table->dateTime("check_in_open")->nullable()->after("briefing");
            $table->dateTime("check_in_end")->nullable()->after("check_in_open");

            $table->dateTime("gate_open")->nullable()->after("check_in_end");
            $table->dateTime("gate_open_ann1")->nullable()->after("gate_open");
            $table->dateTime("gate_open_ann2")->nullable()->after("gate_open_ann1");
            $table->dateTime("gate_close")->nullable()->after("gate_open_ann2");

            $table->dateTime("bus_order")->nullable()->after("gate_close");
            $table->dateTime("bus_1_sent")->nullable()->after("bus_order");
            $table->dateTime("bus_2_sent")->nullable()->after("bus_1_sent");
            $table->dateTime("bus_3_sent")->nullable()->after("bus_2_sent");
            $table->dateTime("bus_last_sent")->nullable()->after("bus_3_sent");
            $table->dateTime("bus_lmc_order")->nullable()->after("bus_last_sent");

            $table->dateTime("boarding_ok")->nullable()->after("bus_lmc_order");
            $table->dateTime("boarding_end")->nullable()->after("boarding_ok");
            $table->dateTime("bridge_driver_order")->nullable()->after("boarding_end");

            $table->integer("wchr")->nullable()->after("bridge_driver_order");
            $table->integer("wchs")->nullable()->after("wchr");
            $table->integer("wchc")->nullable()->after("wchs");
            $table->integer("umnr")->nullable()->after("wchc");
            $table->integer("avih")->nullable()->after("umnr");
            $table->integer("petc")->nullable()->after("avih");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->unsignedInteger('flights_delay_id')->nullable()->after('diverted_airport_id');
            $table->dropColumn([
                'gate_boarding',"capacity_a","pax_a_booked","pax_a_actual","gate_boarding",
                "meals_a","meals_c","meals_y", "briefing","check_in_open","check_in_end",
                "gate_open","gate_open_ann1","gate_open_ann2","gate_close", "bus_order",
                "bus_1_sent", "bus_2_sent", "bus_3_sent", "bus_last_sent", "bus_lmc_order",
                "boarding_ok","boarding_end","bridge_driver_order", "wchr","wchs","wchc",
                "umnr","avih","petc"
            ]);
        });
    }
}
