<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHandlingFlight extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('handling__flights', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('aircraft_id')->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->unsignedInteger('departure_airport_id')->nullable();
            $table->unsignedInteger('arrival_airport_id')->nullable();
            $table->unsignedInteger('diverted_airport_id')->nullable();
            $table->integer('is_diversion')->nullable();

            $table->timestamp('std')->nullable();
            $table->timestamp('ptd')->nullable();
            $table->timestamp('etd')->nullable();
            $table->timestamp('atd')->nullable();
            $table->timestamp('abn')->nullable();

            $table->timestamp('sta')->nullable();
            $table->timestamp('pta')->nullable();
            $table->timestamp('eta')->nullable();
            $table->timestamp('tdn')->nullable();
            $table->timestamp('ata')->nullable();

            $table->integer('capacity_c')->nullable();
            $table->integer('capacity_y')->nullable();

            $table->integer('pax_c_booked')->nullable();
            $table->integer('pax_y_booked')->nullable();
            $table->integer('pax_inf_booked')->nullable();
            $table->integer('pax_c_actual')->nullable();
            $table->integer('pax_y_actual')->nullable();
            $table->integer('pax_inf_actual')->nullable();
            $table->integer('baggage')->nullable();
            $table->integer('cargo')->nullable();
            $table->integer('cargo_200')->nullable();
            $table->integer('mail')->nullable();
            $table->integer('deportees')->nullable();
            $table->integer('in_tanks')->nullable();
            $table->integer('uplifted')->nullable();
            $table->integer('utilised')->nullable();
            $table->string('gate_parking')->nullable();

            $table->timestamp('closed_sales')->nullable();
            $table->string('remark')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('handling__flights');
    }
}
