<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSalesCallsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales__calls', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("organization_id")->nullable();
            $table->unsignedInteger("agency_id")->nullable();
            $table->unsignedInteger("status_id")->nullable();

            $table->dateTime("planned_from")->nullable();
            $table->dateTime("planned_to")->nullable();

            $table->dateTime("actual_from")->nullable();
            $table->dateTime("actual_to")->nullable();

            $table->string("description")->nullable();
            $table->text("conclusion")->nullable();

            $table->string("icon")->nullable();
            $table->string("color")->nullable();

            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('sales__calls');
    }
}
