<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeColumnReceivedDateInFlightsMvtMessages extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__mvt_messages', function (Blueprint $table) {
            $table->dropColumn('received_date');
            $table->timestamp('received_datetime')->nullable()->after("flight_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__mvt_messages', function (Blueprint $table) {
            $table->dropColumn('received_datetime');
            $table->string('received_date')->nullable()->after("flight_id");
        });
    }
}
