<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIsoCodesToCountries extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('countries', function (Blueprint $table) {
            $table->string('iso_alpha_3', 3)->nullable()->after('abbr');
            $table->integer('iso_numeric')->nullable()->after('iso_alpha_3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('countries', function (Blueprint $table) {
           $table->dropColumn(['iso_alpha_3', 'iso_numeric']);
        });
    }
}
