<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMhbBaggageDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mhb__baggage_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('mhb_baggage_id');
            $table->foreign('mhb_baggage_id')
                ->references('id')
                ->on('mhb__baggage')
                ->onDelete('CASCADE')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('departure_airport_id')->nullable();
            $table->foreign('departure_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('arrival_airport_id')->nullable();
            $table->foreign('arrival_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->string('flight_number')->nullable();
            $table->dateTime('date_time')->nullable();
            $table->dateTime('sta')->nullable();
            $table->dateTime('ata')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('mhb__baggage_details');
    }
}
