<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMhbBaggage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mhb__baggage', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger('mhb_id');
            $table->foreign('mhb_id')
                ->references('id')
                ->on('mhb')
                ->onDelete('CASCADE')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('carrier_id')->nullable();
            $table->foreign('carrier_id')
                ->references('id')
                ->on('airlines')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->string('baggage_tag_no')->nullable();

            $table->unsignedInteger('baggage_type_id')->nullable();
            $table->foreign('baggage_type_id')
                ->references('id')
                ->on('baggage__types')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('baggage_color_id')->nullable();
            $table->foreign('baggage_color_id')
                ->references('id')
                ->on('baggage__colors')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('brand_name_id')->nullable();
            $table->foreign('brand_name_id')
                ->references('id')
                ->on('baggage__brand_names')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->text('contents')->nullable();
            $table->boolean('whs')->nullable();

            $table->string('damage_type')->nullable();
            $table->text('damage_description')->nullable();
            $table->string('side1')->nullable();
            $table->string('side2')->nullable();
            $table->string('end1')->nullable();
            $table->string('end2')->nullable();
            $table->string('top')->nullable();
            $table->string('bottom')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('mhb__baggage');
    }
}
