<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFlightRouteIdToFlightsNumbers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
            $table->unsignedInteger('flight_route_id')->nullable()->after('flight_number');
            $table->foreign('flight_route_id')
                ->references('id')
                ->on('flights__routes')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__numbers', function (Blueprint $table) {
            $table->dropForeign('flights__numbers_flight_route_id_foreign');
            $table->dropColumn(['flight_route_id']);
        });
    }
}
