<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsRoutesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('flights__routes', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('from_airport_id')->nullable();
            $table->foreign('from_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('to_airport_id')->nullable();
            $table->foreign('to_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('flight_type_id')->nullable();
            $table->foreign('flight_type_id')
                ->references('id')
                ->on('flights__types')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->integer('duration')->nullable();
            $table->float('distance')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__routes');
    }
}
