<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToCrewRosters extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('crew__rosters', function(Blueprint $table)
		{
			$table->integer('total_crew')->nullable()->after("status");
			$table->integer('total_flights')->nullable()->after("total_crew");
			$table->integer('flt_no_crew')->nullable()->after("total_flights");
			$table->integer('flt_no_min_req')->nullable()->after("flt_no_crew");
			$table->integer('flt_no_standby')->nullable()->after("flt_no_min_req");
			$table->boolean('is_pseudo')->nullable()->after("flt_no_standby");
			$table->text('admin_settings')->nullable()->after("is_pseudo");
			$table->text('other_settings')->nullable()->after("admin_settings");
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('crew__rosters', function(Blueprint $table)
		{
			$table->dropColumn([
				'total_crew',
				'total_flights',
				'flt_no_crew',
				'flt_no_min_req',
				'flt_no_standby',
				'is_pseudo',
				'admin_settings',
				'other_settings',
			]);
		});
	}

}
