<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToPassengersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('passengers', function(Blueprint $table)
		{
			$table->boolean('is_vip')->nullable()->after('middle_name');
			$table->string('company')->nullable()->after('is_vip');
			$table->string('position')->nullable()->after('company');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('passengers', function(Blueprint $table)
		{
			$table->dropColumn(['is_vip', 'company', 'position']);
		});
	}

}
