<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCrewRosterDetails extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('crew__rosters_details', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');

			$table->unsignedInteger('crew_roster_id')->nullable();
			$table->foreign('crew_roster_id')
				->references('id')
				->on('crew__rosters')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->unsignedInteger('flight_id')->nullable();
			$table->foreign('flight_id')
				->references('id')
				->on('flights')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->unsignedInteger('user_id')->nullable();
			$table->foreign('user_id')
				->references('id')
				->on('users')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->unsignedInteger('position_id')->nullable();
			$table->foreign('position_id')
				->references('id')
				->on('structure__positions')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->integer('position_order')->nullable();
			$table->boolean('is_standby')->nullable();
			$table->boolean('is_dhc')->nullable();

			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('crew__rosters_details');
	}

}
