<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusIdToMhb extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('mhb', function(Blueprint $table)
		{
			$table->unsignedInteger('status_id')->nullable()->after('airport_id');
			$table->foreign('status_id')
				->references('id')
				->on('application_status')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('mhb', function(Blueprint $table)
		{
			$table->dropForeign('mhb_status_id_foreign');
			$table->dropColumn('status_id');
		});
	}

}
