<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExceededToUserLeaveRequests extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('users__leave_requests', function(Blueprint $table)
		{
			$table->integer('exceeded_days')->nullable()->after('working_days');
			$table->enum('type', ['Calendar', 'Working'])->nullable()->after('date_to');
			$table->renameColumn('calendar_days','days');
			$table->dropColumn('working_days');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('users__leave_requests', function(Blueprint $table)
		{
			$table->dropColumn(['exceeded_days', 'type']);
			$table->renameColumn('days','calendar_days');
			$table->integer('working_days')->nullable()->after('date_to');
		});
	}

}
