<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersEntitlements extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__entitlements', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('user_id');
			$table->foreign('user_id')
				->references('id')
				->on('users')
				->onDelete('CASCADE')
				->onUpdate('CASCADE');

			$table->integer('year');
			$table->integer('entitlement');
			$table->enum('type', ['Calendar', 'Working'])->nullable();
			$table->integer('pending')->nullable();
			$table->integer('used')->nullable();

			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__entitlements');
	}

}
