<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMhbTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('mhb', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('type_id')->nullable();
			$table->foreign('type_id')
				->references('id')
				->on('mhb__types')
				->onDelete('CASCADE')
				->onUpdate('CASCADE');
			$table->unsignedInteger('airport_id')->nullable();
			$table->foreign('airport_id')
				->references('id')
				->on('airports')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->string('carrier')->nullable();
			$table->string('file_reference')->unique();
			$table->string('lz_ind')->nullable();
			$table->string('last_name');
			$table->string('initials')->nullable();
			$table->string('title')->nullable();
			$table->string('ticket_number')->nullable();
			$table->string('passport_number')->nullable();
			$table->double('received_baggage_weight')->nullable();
			$table->double('checked_baggage_weight')->nullable();
			$table->text('forwarding_instructions')->nullable();
			$table->text('permanent_address')->nullable();
			$table->text('permanent_phone')->nullable();
			$table->text('temporary_address')->nullable();
			$table->text('temporary_phone')->nullable();
			$table->text('local_delivery_instructions')->nullable();
			$table->string('lock_code')->nullable();
			$table->boolean('keys_attached')->nullable();
			$table->string('language')->nullable();
			$table->text('loss_reason')->nullable();
			$table->date('report_date')->nullable();
			$table->boolean('agent_signed')->nullable();
			$table->boolean('passenger_signed')->nullable();

			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('mhb');
	}

}
