<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBaggageColors extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('baggage__colors', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->string('code');
			$table->text('color')->nullable();
			$table->text('notes')->nullable();
			$table->text('image')->nullable();
			$table->text('barcode_image')->nullable();
			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('baggage__colors');
	}

}
