<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterAirportsAddNewFields extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('airports', function(Blueprint $table)
		{
			$table->boolean('operated')->after('name')->default(false);
			$table->renameColumn('abbr', 'iata');

			$table->string('icao')->nullable()->after('abbr');
			$table->unsignedInteger('country_id')->nullable()->after('city_id');
			$table->integer('elevation')->nullable()->after("country_id");
			$table->double('latitude', 12, 9)->nullable()->after('elevation');
			$table->double('longitude', 12, 9)->nullable()->after('latitude');
			$table->string('timezone')->nullable()->after('longitude');
			$table->foreign('country_id')
				->references('id')
				->on('countries')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('airports', function(Blueprint $table)
		{
			$table->renameColumn('iata', 'abbr');
			$table->dropForeign('airports_country_id_foreign');
			$table->dropColumn(['operated', 'country_id','icao', 'elevation','latitude','longitude','timezone']);
		});
	}

}
