<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIataAirline extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('iata__airlines', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->string('airline');
			$table->unsignedInteger('country_id')->nullable();
			$table->string('iata')->nullable();
			$table->string('icao')->nullable();
			$table->string('callsign')->nullable();
			$table->string('country')->nullable();
			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();

			$table->foreign('country_id')
				->references('id')
				->on('countries')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('iata__airlines');
	}

}
