<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersLeaveStatusTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__leave_status', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('request_id');
			$table->foreign('request_id')
				->references('id')
				->on('users__leave_requests')
				->onDelete('CASCADE')
				->onUpdate('CASCADE');
			$table->unsignedInteger('status_id')->nullable();
			$table->foreign('status_id')
				->references('id')
				->on('application_status')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->unsignedInteger('report_to_user_id')->nullable();
			$table->foreign('report_to_user_id')
				->references('id')
				->on('users')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->text('notes')->nullable();
			$table->boolean('is_ceo')->nullable();
			$table->boolean('is_hr')->nullable();
			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__leave_status');
	}

}
