<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersLeaveRequestsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__leave_requests', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('user_id')->nullable();
			$table->foreign('user_id')
				->references('id')
				->on('users')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->unsignedInteger('leave_id')->nullable();
			$table->foreign('leave_id')
				->references('id')
				->on('leaves')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->unsignedInteger('status_id')->nullable();
			$table->foreign('status_id')
				->references('id')
				->on('application_status')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
			$table->dateTime('date_from');
			$table->dateTime('date_to');
			$table->integer('calendar_days')->nullable();
			$table->integer('working_days')->nullable();
			$table->text('reasons')->nullable();
			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__leave_requests');
	}

}
