<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightDelaysTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('flights__delays', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('flight_id');
			$table->unsignedInteger('delay_id');
			$table->integer('order')->default(1);
			$table->time('duration')->nullable();

			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();

			$table->foreign('flight_id')
				->references('id')
				->on('flights')
				->onDelete('CASCADE')
				->onUpdate('CASCADE');

			$table->foreign('delay_id')
				->references('id')
				->on('delays')
				->onDelete('CASCADE')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('flights__delays');
	}

}
