<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDivertedAirportIdToFlights extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->unsignedInteger('diverted_airport_id')->nullable()->after('arrival_airport_id');
			$table->foreign('diverted_airport_id')
				->references('id')
				->on('airports')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->dropForeign('flights_diverted_airport_id_foreign');
			$table->dropColumn('diverted_airport_id');
		});
	}

}
