<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPrevNextFlightIdsToFlights extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->unsignedInteger('prev_flight_id')->nullable()->after('parent_id');
			$table->foreign('prev_flight_id')
				->references('id')
				->on('flights')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->unsignedInteger('next_flight_id')->nullable()->after('prev_flight_id');
			$table->foreign('next_flight_id')
				->references('id')
				->on('flights')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->dropForeign('flights_prev_flight_id_foreign');
			$table->dropForeign('flights_next_flight_id_foreign');
			$table->dropColumn(['prev_flight_id', 'next_flight_id']);
		});
	}

}
