<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDepartureArrivalAirportIdsToFlights extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->unsignedInteger('departure_airport_id')->nullable()->after('flight_number_id');
			$table->foreign('departure_airport_id')
				->references('id')
				->on('airports')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->unsignedInteger('arrival_airport_id')->nullable()->after('departure_airport_id');
			$table->foreign('arrival_airport_id')
				->references('id')
				->on('airports')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights', function(Blueprint $table)
		{
			$table->dropForeign('flights_departure_airport_id_foreign');
			$table->dropForeign('flights_arrival_airport_id_foreign');
			$table->dropColumn(['departure_airport_id', 'arrival_airport_id']);
		});
	}

}
