<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDutyToUsersHistoryTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('users__history', function(Blueprint $table)
		{
			$table->time('duty_from')->nullable()->after('condition_to');
			$table->time('duty_to')->nullable()->after('duty_from');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('users__history', function(Blueprint $table)
		{
			$table->dropColumn(['duty_from', 'duty_to']);
		});
	}

}
