<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDivertedFlightIdToFlightsCrew extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights__crew', function(Blueprint $table)
		{
			$table->unsignedInteger('diverted_flight_id')
				->nullable()
				->after('flight_id');
			$table->foreign('diverted_flight_id')
				->references('id')
				->on('flights__diverted')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights__crew', function(Blueprint $table)
		{
			$table->dropForeign('flights__crew_diverted_flight_id_foreign');
			$table->dropColumn('diverted_flight_id');
		});
	}

}
