<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSupToFlightsCrew extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights__crew', function(Blueprint $table)
		{
			$table->boolean('is_sup')->default(false)->after('is_dhc');
			$table->unsignedInteger('crew_sup_id')->nullable()->after('is_sup');
			$table->foreign('crew_sup_id')
				->references('id')
				->on('crew__sup')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights__crew', function(Blueprint $table)
		{
			$table->dropForeign('flights__crew_crew_sup_id_foreign');
			$table->dropColumn(['is_sup', 'crew_sup_id']);
		});
	}
}
