<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersChatTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__chat', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
			$table->unsignedInteger('from_user_id')->nullable();
			$table->unsignedInteger('to_user_id')->nullable();
			$table->text('message')->nullable();
			$table->boolean('read')->default(false);
			$table->dateTime('sent')->nullable();
			$table->boolean('blocked')->default(false);
			$table->nullableTimestamps();
			$table->unsignedInteger('created_by')->nullable();
			$table->unsignedInteger('updated_by')->nullable();
			$table->softDeletes();

			$table->foreign('from_user_id')
				->references('id')
				->on('users')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

			$table->foreign('to_user_id')
				->references('id')
				->on('users')
				->onDelete('SET NULL')
				->onUpdate('CASCADE');

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__chat');
	}

}
