<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddQuarterMonthToRevenueTargetsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
			$table->integer('quarter')->nullable()->after('period_to');
			$table->integer('month')->nullable()->after('quarter');
            $table->unsignedInteger('parent_id')->nullable()->after('target');

            $table->foreign('parent_id')
                ->references('id')
                ->on('revenue__targets')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
			$table->dropForeign('revenue__targets_parent_id');
            $table->dropColumn(['parent_id', 'month', 'quarter']);
		});
	}

}
