<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveCurrencyIdFromRevenueTargets extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
			$table->dropForeign('revenue__targets_currency_id_foreign');
            $table->dropColumn('currency_id');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
            $table->unsignedInteger('currency_id')->nullable()->after('type_id');
            $table->foreign('currency_id')
                ->references('id')
                ->on('currency')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

}
