<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPeriodIdToRevenueTarget extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
            $table->unsignedInteger('period_id')->nullable()->after('id');

            $table->foreign('period_id')
                ->references('id')
                ->on('revenue__targets_periods')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
			$table->dropForeign('revenue__targets_period_id_foreign');
            $table->dropColumn('period_id');
		});
	}

}
