<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRevenueTargetsPeriods extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('revenue__targets_periods', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->date('period_from');
            $table->date('period_to');
            $table->integer('target')->nullable();
            $table->unsignedInteger('network_organization_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('currency_id')
                ->references('id')
                ->on('currency')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('network_organization_id')
                ->references('id')
                ->on('organization')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('revenue__targets_periods');
	}

}
